"$.ggobi" <-
#
# The idea of this function is to simplify the syntax for invoking
# ggobi functions which use the .ggobi suffix.
# Users have different ggobi instances as S variables (i.e. not
# using indices or the default ggobi via getDefaultGGobi())
# and they invoke the methods on this instance via the OOP notation
#  
#     g$getPlotCount()
# and the `static'/class function
#     g$getDisplayTypes()
#
# This defines a syntax trick to allow calls of the form
#  (where g is an object of class ggobi)
#
# g$getDisplayCount() 
# g$setData(mtcars)
#
# which are really translations from
#  g$name(..)  ->  name.ggobi( ..., .gobi = g)
#  
function(x, name)
{
 .funName <- paste(name,"ggobi",sep=".")

 if(exists(.funName, mode="function")) {
   .fun <- get(.funName, mode="function")
    # Check if the function has a .gobi argument to see if it
    # is an instance method or class method
    uses.ggobi <- !is.na(match(".gobi", names(formals(.fun))))
    if(uses.ggobi) {
      function(...) {
       .fun(...,.gobi=x)
      }
    } else {
     .fun
    }

 } else {
    do.call("$", list(unclass(x)[["ref"]], name))
 }
}

