createEdgeDataset.ggobi <-
  #
  # This creates an empty dataset, i.e with no variables,
  # but with a specified number of rows. This can then be used
  # to create an edge dataset. Hence the name.
  #
function(n, name = "<empty>", description = "Empty dataset!", add = TRUE,
          ids = as.character(seq(1, n)), .gobi = getDefaultGGobi())
{
  d <- .Call(.ggobi.symbol("createEmptyData"), as.integer(n), as.character(name),
               as.character(description), .gobi = .gobi, PACKAGE = "Rggobi")
  setRowNames.ggobi(ids, .data = d, .gobi = .gobi)
  d
}


ggobi <-
#
# Start a ggobi session
# data can be the name of a file, or data frame or matrix.
#
# Returns the index of the ggobi instance within 
# the session. If an error occurs, -1 is returned.
#
# see setData.ggobi
#     setDataFile.ggobi
#
function(data = NULL, args=character(0), mode=character(0), name = deparse(sys.call()[[2]]), ...)
{
 args <- c(paste(ggobi.home(), "ggobi", sep=.Platform$file.sep), c("--keepalive", as.character(args)))

 fileName = character(0)
 if(!missing(data) && is.character(data) && file.exists(data)) {
   fileName <- path.expand(data)
   data <- NULL
 } else {
    if(missing(mode)) 
      mode = "-s"
 }

  args <- c(args, as.character(mode), fileName)   

  # No longer do this. It sets a global option so next time we read a file, it thinks it is S data.
  # XXX Fix this.
  # else  args <- c(args, "-s")

 ok <- .Call(.ggobi.symbol("init"), args, TRUE, PACKAGE = "Rggobi")

 if(!is.null(ok)) {
   # So we didn't get an error.
   # Set this new ggobi to be default instance
   # so that subsequent commands will operate
   # on it.
  setDefaultGGobi(ok) 

   #
  if(!missing(data) && !is.null(data))
    setData.ggobi(data, name = name, ..., .gobi = ok)
 }

 return(ok)
}

setData.ggobi <-
function(data, name = deparse(sys.call()[[2]]), ..., .gobi = getDefaultGGobi())
{
 if(is.character(data)) {
  ok <- setDataFile.ggobi(data, ..., .gobi = .gobi)
 } else {
  ok <- setDataFrame.ggobi(as.data.frame(data), name = name, ..., .gobi = .gobi)
 }

 return(ok)
}


setDataFile.ggobi <-
function(file, mode = "unknown", add = TRUE, .gobi = getDefaultGGobi())
{
 if(FALSE && is.character(file)) {
   modes <- getDataModes.ggobi()
   mode <- match(mode, modes)
   if(is.na(mode)) {
     mode <- modes["Unknown"]
   } else
     mode <- modes[mode]
 }

 num <- .GGobiCall("setFile", as.character(file), as.character(mode), as.logical(add), .gobi = .gobi)
 if(num > -1) {
   getDatasetReference.ggobi(num, .gobi)
 } else
   NULL
}


getNumDatasets.ggobi <-
function(.gobi = getDefaultGGobi())
{
 .GGobiCall("getNumDatasets", .gobi=.gobi)
}

getFileNames.ggobi <-
#
# Get the name and mode of the file
# associated with the current dataset.
function(auxillary = FALSE, .gobi = getDefaultGGobi())
{
  .GGobiCall("getFileNames", as.logical(auxillary), .gobi = .gobi)
}

setDataFrame.ggobi <-
function(data, name = description, description = deparse(sys.call()[[2]]), 
            add = TRUE, id = rownames(data), .data = NULL, .gobi = getDefaultGGobi())
{

 # description was 

  n <- dimnames(data)
  if(!inherits(.gobi, "ggobi")) {
   .gobi <- getGGobi(as.integer(.gobi))
  }

  if(length(id) != nrow(data)) {
    id <- paste(seq(1, nrow(data)))
  }

  if(any(sapply(data, is.factor))) {
    .data = .Call(.ggobi.symbol("setData"),
                   NULL,
                   n[[1]], n[[2]], dim(data), 
                   as.character(description), as.character(name), as.logical(add),
                   as.character(id), .data, .gobi = .gobi,
                   PACKAGE = "Rggobi")

    for(i in names(data)) {
      addVariable.ggobi(data[[i]], i, .data = .data, .gobi = .gobi)
    }

      # Ideally, we would like this to happen in the C call to
      # GGOBI(setData) in the C code.  But this is only called currently
      # if we have numeric values only. Fix that to consolidate the code.
    setRowNames.ggobi(rownames(data), .data = .data, .gobi = .gobi)

# This call to datad_init is too late.    
#    .GGobiCall("datad_init", FALSE, as.integer(.data-1), .gobi = .gobi)
# but varpanel_populate works here because the vartabled list is
# now sufficiently long (i.e. > 0) to force the tab to be added to the
# notebook in the control panel.    
    
    .GGobiCall("varpanel_populate", as.integer(.data-1), .gobi = .gobi)    
    
    num <- .data
    if(ncol(data) > 1 && length(getDisplays.ggobi(.gobi = .gobi)) == 0)
      scatterplot.ggobi(1, 2, .data, .gobi = .gobi)
  } else
    num <- .Call(.ggobi.symbol("setData"),
                  as.numeric(as.matrix(data)),
                  n[[1]], n[[2]], dim(data), 
                  as.character(description), as.character(name), as.logical(add),
                  as.character(id), .data, .gobi = .gobi,
                   PACKAGE = "Rggobi")


 getDatasetReference.ggobi(num, .gobi)
}


setGeneric("getDatasetReference",
            function(which, .gobi = getDefaultGGobi(), simplify = TRUE)
              standardGeneric("getDatasetReference"))

setMethod("getDatasetReference", "numeric",
          function(which, .gobi = getDefaultGGobi(), simplify = TRUE)
          {
            getDatasetReference.ggobi(which, .gobi)
          })


setMethod("getDatasetReference", "ggobiDataset",
          function(which, .gobi = getDefaultGGobi(), simplify = TRUE)
            which
          )



setMethod("getDatasetReference", "ggobiDisplayDescription",
          function(which, .gobi = getDefaultGGobi(), simplify = TRUE)
             which[["dataset"]]
)

setMethod("getDatasetReference", "ggobiDisplay",
          function(which, .gobi = getDefaultGGobi(), simplify = TRUE)
             getDisplayDataset.ggobi(which, .gobi)
)

getDisplayDataset.ggobi <-
function(dpy, .gobi = getDefaultGGobi())
{
 .GGobiCall("getDisplayDataset", dpy, .gobi = .gobi)
}


getDatasetReference.ggobi <-
function(which, .gobi = getDefaultGGobi(), simplify = TRUE)
{
 if(is.character(which)) {
   id <- match(which, getDatasetNames.ggobi(.gobi))
   if(any(is.na(id)))
     stop(paste("Unrecognized dataset name", which[is.na(id)]))

   which <- id
 }

 refs <- .GGobiCall("getDatasetReference", as.integer(which-1), .gobi=.gobi)


 refs = lapply(refs, function(x) {if(is.null(x)) return(NULL) ; class(x) <- c(class(x), "data.frame"); x}) 
 
  # if the user just asked for one, then return not a list,
  # but the actual ggobiDataset object. i.e. remove the list.
# This isn't a good idea!
 if(simplify && length(which) == 1 & length(refs) == 1) {
   refs <- refs[[1]]
 }

 refs
}




getCurrentDisplayType.ggobi <-
#
# Returns a description of the type
# of display which is the active or current
# one.
#
function(.gobi = getDefaultGGobi())
{
  .GGobiCall("getCurrentDisplayType", .gobi = .gobi)
}


getDisplayTypes.ggobi <-
function()
{
 .Call(.ggobi.symbol("getDisplayTypes"), PACKAGE = "Rggobi")
}



getDisplayOptions.ggobi <-
#
# Retrieve the display options for the 
# specified display. The default is to get
# the template default options which are used when
# creating a new display/plot.
# Alternatively, one can specify an integer which identifies
# the display (window) and its sub-plots.
# These are stored in ordered and can be examined using
# the hierarchical display tree accessed from the Plots
# menu item.

#
# which - the display number within the specified ggobi instance.
#

function(which = 1, .gobi = getDefaultGGobi())
{
  ans = .GGobiCall("getDisplayOptions", as.integer(which-1), .gobi = .gobi)
  class(ans) = "GGobiDisplayOptions"

  ans
}


setDisplayOptions.ggobi <-
#
# Changes the settings of the display options for a
# collection of plots or the template options for future
# plots.
#
#
# The argument `which' identifies the GGobi display (this is an index
# into the ordered list of displays viewable via the hierarchical dislay
# tree). If this is negative, the Default options used when creating new
# plots will be modified.
#
# The return value is the current settings for the specified options.
#
# Need to sort current if specified.
#
function(points,
         axes, axesLabels, axesValues,
         directed, undirected, arrowheads,
         whiskers,
         current = NULL,
          display = 1, .gobi = getDefaultGGobi())
{
  old <- getDisplayOptions.ggobi(display, .gobi=.gobi)
  
  if(is.null(current)) {
    current = old
  } else {
    if(length(names(current)) == 0) {
      stop("Need named components")
    } else {
      which = pmatch(names(current), names(old))
      if(any(is.na(which)))
        stop("Unknown element(s)", paste(names(current)[is.na(which)], sep=", "))
       # Now reorder current so that the names are
      tmp = old
      tmp[which] = current
      current = tmp
    }
  }

  if(!missing(points))
    current["Show Points"] <- as.logical(points)

  if(!missing(axes))
    current["Show axes"] <- as.logical(axes)

  if(!missing(axesValues))
    current["Show tour axes"] <- as.logical(axes)

  if(!missing(axesLabels))
    current["Show axes labels"] <- as.logical(axes)        
    
  if(!missing(directed))
    current["Directed edges"] <- as.logical(directed)

  if(!missing(undirected))
    current["Undirected edges"] <- as.logical(undirected)

    
  if(!missing(arrowheads))
    current["Arrowheads"] <- as.logical(arrowheads)

  if(!missing(whiskers)) 
    current["Show whiskers"] <- as.logical(whiskers)


  
  .GGobiCall("setDisplayOptions", as.integer(display - 1), current, .gobi = .gobi)

 return(old)
}



getActivePlot.ggobi <-
function(.gobi = getDefaultGGobi())
{
 as.integer(.GGobiCall("getActivePlot", .gobi = .gobi)+1)
}

setActivePlot.ggobi <-
function(display, plot=1, .gobi = getDefaultGGobi())
{
 .GGobiCall("setActivePlot", as.integer(c(display, plot)-1), .gobi = .gobi)
}

getDisplays.ggobi <-
function(describe = FALSE, .gobi = getDefaultGGobi())
{
 .GGobiCall("getDisplays", as.logical(describe), .gobi = .gobi)
}


close.ggobiDisplayDescription <-
function(con, ...)
{
 close(con[["display"]])
}

close.ggobiDisplay <-
function(con, ...)
{
  .GGobiCall("closeDisplay", con[["ref"]], .gobi = con[["ggobi"]])
}

getDatasetNames.ggobi <-
function(.gobi = getDefaultGGobi())
{
 .GGobiCall("getDatasetNames", .gobi=.gobi)
}

getDescription.ggobi <-
#
# Get a description of the global state of the GGobi session.
# 
#
function(.gobi = getDefaultGGobi())
{
  ans = .GGobiCall("getDescription", .gobi = .gobi)

  dimnames(ans$"Data dimensions") =  list(ans$Fileame, c("nrow", "ncol"))

  ans
}



getVariableNames.ggobi <-
function(tform = FALSE, .data = 1, .gobi = getDefaultGGobi())
{
  if(!inherits(.gobi, "ggobi"))
   .gobi <- getGGobi(.gobi = .gobi)

  if(mode(.data) == "numeric")
    .data <- as.integer(.data - 1)

  .GGobiCall("getVariableNames", as.logical(tform), .data, .gobi = .gobi)
}

datasetIndex.ggobi <-
function(.data, .gobi = getDefaultGGobi())
{
 if(is.integer(.data))
   return(.data)

 if(mode(.gobi) == "numeric")
   .gobi <- getGGobi(.gobi)
 
 index <- match(as.character(.data), names(.gobi))
 names(index) <- .data

 return(index)
}


getGlyphTypes.ggobi <-
function()
{
 .Call(.ggobi.symbol("getGlyphTypes"), PACKAGE = "Rggobi")
}

getGlyphSizes.ggobi <-
function()
{
 .Call(.ggobi.symbol("getGlyphSizes"), PACKAGE = "Rggobi")
}


getGlyphs.ggobi <-
function(which=NULL, .data = 1, .gobi = getDefaultGGobi())
{
 if(mode(.data) == "numeric")
   .data <- as.integer(.data - 1)

 if(!is.null(which)) {
   which <- as.integer(which-1)
 }

 .GGobiCall("getCaseGlyphs", which, .data, .gobi = .gobi)
}

setGlyphs.ggobi <-
function(types, sizes, which, .data=1, .gobi = getDefaultGGobi())
{
 if(mode(.data) == "numeric")
    .data <- as.integer(.data - 1)

 if(is.character(types)) {
    # map the glyph types to integers
   types <- mapGlyphType(types)
 }

 if(missing(which))
   which <- seq(1, length = length(types))

 if(missing(sizes)) {
   sizes <- rep(-1, length(types))
 }

 m <- max(length(which), length(sizes), length(types))
 which <- rep(which, length.out = m)
 sizes <- rep(sizes, length.out = m)
 types <- rep(types, length.out = m)

 if(any( c(length(which), length(sizes), length(which)) == 0))
   stop("Non-zero glyph attributes needed")

 .GGobiCall("setCaseGlyphs", as.integer(types), as.integer(sizes), as.integer(which-1), .data, .gobi = .gobi)
}


getColors.ggobi <-
function(which = NULL, .data = 1, .gobi = getDefaultGGobi())
{
 if(mode(.data) == "numeric")
   .data <- as.integer(.data - 1)

 .GGobiCall("getCaseColors", as.integer(which), .data,  .gobi = .gobi)
}

setColors.ggobi <-
function(colors, which = 1:length(colors), .data=1, .gobi = getDefaultGGobi())
{
 if(mode(colors) == "numeric")
   colors <- as.integer(colors)
 else {
   tmp <- resolveColors.ggobi(as.character(colors), .gobi = .gobi)
   if(any(is.na(tmp)))
     stop(paste("Unspecified color(s)", colors[is.na(tmp)]))

    colors <- tmp
 }

 if(mode(.data) == "numeric")
   .data <- as.integer(.data - 1)

 if(any(colors < 1) || any(colors > 65535))
    stop("All color indices must be positive and less than 65536.")
 
 old <- .GGobiCall("setCaseColors", colors, as.integer(which-1), .data, .gobi = .gobi)
 invisible(old)
}





setMissing.ggobi <-
function(which, .data=1, .gobi = getDefaultGGobi())
{
 if(mode(.data) == "numeric")
   .data <- as.integer(.data - 1)

 old <- .GGobiCall("setMissing", which, .data, .gobi = .gobi)

 invisible(old)
}


close.ggobi <-
function(con = getDefaultGGobi(), ...)
{
  if(missing(con))
     con <- getDefaultGGobi()
  
  ok <- .GGobiCall("close", .gobi = con)
  if(ok) {
    cur <-getDefaultGGobi()
    if(.Call("isSameRef", unclass(con)$ref, unclass(cur)$ref, PACKAGE = "Rggobi")) {
      setDefaultGGobi(getNumGGobis()) 
    }
  }

 ok
}


getNumGGobis <-
function()
{
 .C(.ggobi.symbol("getNumGGobiInstances"), num = as.integer(-1), PACKAGE = "Rggobi")$num
}

isValid.ggobi <-
function(.gobi)
{
 .GGobiCall("isValid", .gobi=.gobi)
}

getGGobi <-
function(...)
{
 args <- list(...)
 if(length(args) > 0) {
   which <- sapply(args, as.integer)
 } else {
   which <- as.integer(seq(1,length=getNumGGobis()))
 }

 if(length(which)) {
   v <- .Call("RS_GGOBI_getGGobi", which, PACKAGE = "Rggobi")
   if(!is.null(v) & length(which) == 1) {
    v <- v[[1]]
   }

   v
 } else
   NULL
}


setMode.ggobi <-
function(name, .gobi = getDefaultGGobi())
{
 old <- getMode.ggobi(.gobi) 
 .GGobiCall("setMode",  as.character(name), .gobi=.gobi)

 old
}

getMode.ggobi <-
function(.gobi = getDefaultGGobi())
{
 .GGobiCall("getModeName", .gobi=.gobi)
}

getModeNames.ggobi <-
function()
{
  .Call(.ggobi.symbol("getModeNames"), PACKAGE = "Rggobi")
}

getDataModes.ggobi <-
function()
{
 .Call(.ggobi.symbol("getDataModes"), PACKAGE = "Rggobi")
}


gdk.flush <-
function()
{
  .C(.ggobi.symbol("flush"), PACKAGE = "Rggobi")
}


getHiddenCases.ggobi <-
function(.data = 1, .gobi = getDefaultGGobi())
{
 if(mode(.data) == "numeric")
   .data <- as.integer(.data - 1)

 .GGobiCall("getCasesHidden", .data = .data, .gobi=.gobi)
}

setHiddenCases.ggobi <-
function(vals, which = 1:length(vals), .data = 1, .gobi = getDefaultGGobi())
{
 vals <- as.logical(vals)
 if(mode(.data) == "numeric")
   .data <- as.integer(.data - 1)

 .GGobiCall("setCasesHidden", vals, as.integer(which-1), .data = .data, .gobi=.gobi)
}


getCurrentDisplay.ggobi =
function(.gobi = getDefaultGGobi())
{
  obj = .GGobiCall("getCurrentDisplay", .gobi = .gobi)

  library(RGtk)
  class(obj) = gtkObjectGetClasses(obj, FALSE)

  obj  
}  

getMainWindow.ggobi =
function(.gobi = getDefaultGGobi())
{
  obj = .GGobiCall("getMainWindow", .gobi = .gobi)

  library(RGtk)
  class(obj) = gtkObjectGetClasses(obj, FALSE)

  obj
}


getMenuBar.ggobi =
  #
  #
  #
  function(.gobi = getDefaultGGobi())
{
  ans = .GGobiCall("getMenubar", .gobi = .gobi)
  if(!is.null(ans)) {
    library(RGtk)
    class(ans) = gtkObjectGetClasses(ans, FALSE)
  }
  ans
}  


asGtkWidget =
function(obj)
{
 w =  unclass(obj)$ref
# class(w) = gtkObjectGetClasses(w, FALSE)

 w
}
